#!/bin/sh

if [ $# -ne 1 ]; then
    echo "Usage: `basename $0` <upgrade package name>"
    exit 1
fi

echo "move postgresql rpms to sub folder"
cat packages/postgresql_rpms/rpm.txt | xargs -I{} mv packages/{} packages/postgresql_rpms/
echo "copy postgresql dependency rpms to sub folder"
cat packages/postgresql_rpms/dependency_rpm.txt | xargs -I{} cp -f packages/{} packages/postgresql_rpms/

echo "move elasticseaerch rpms to sub folder"
cat packages/productUpdate/rpm.txt | xargs -I{} mv packages/{} packages/productUpdate/
echo "move pixiebob_logReceiver rpm to sub folder"
mv packages/pixiebob_logReceiver*.rpm packages/productUpdate/


find -type f |xargs md5sum MD5SUM.txt | grep -v MD5SUM | grep -v Makefile > MD5SUM.txt

tar -h -czf $1 ./* --exclude="Makefile" > /dev/null 2>&1
